import React, { useState } from 'react';
import { Wallet } from '../types';

interface TransferFundsProps {
    selectedWallet: Wallet | null;
    amount: number;
    onTransfer: (amount: number) => void;
}

const TransferFunds: React.FC<TransferFundsProps> = ({ selectedWallet, amount, onTransfer }) => {
    const [transferAmount, setTransferAmount] = useState<number>(amount);
    const [isTransferring, setIsTransferring] = useState<boolean>(false);
    const [error, setError] = useState<string | null>(null);

    const handleTransfer = async () => {
        if (!selectedWallet) {
            setError('No wallet selected');
            return;
        }

        setIsTransferring(true);
        setError(null);

        try {
            // Logic to interact with the wallet provider and initiate the transfer
            await onTransfer(transferAmount);
            alert('Transfer successful!');
        } catch (err) {
            setError('Transfer failed. Please try again.');
        } finally {
            setIsTransferring(false);
        }
    };

    return (
        <div>
            <h2>Transfer Funds</h2>
            <input
                type="number"
                value={transferAmount}
                onChange={(e) => setTransferAmount(Number(e.target.value))}
                placeholder="Amount to transfer"
            />
            <button onClick={handleTransfer} disabled={isTransferring}>
                {isTransferring ? 'Transferring...' : 'Transfer'}
            </button>
            {error && <p style={{ color: 'red' }}>{error}</p>}
        </div>
    );
};

export default TransferFunds;