import React, { useState } from 'react';
import NetworkSelector from '../components/NetworkSelector';
import WalletOptions from '../components/WalletOptions';
import ConnectWalletButton from '../components/ConnectWalletButton';
import PermissionRequest from '../components/PermissionRequest';
import TransferFunds from '../components/TransferFunds';

const App: React.FC = () => {
    const [selectedNetwork, setSelectedNetwork] = useState<string | null>(null);
    const [selectedWallet, setSelectedWallet] = useState<string | null>(null);
    const [isConnected, setIsConnected] = useState<boolean>(false);
    const [isPermissionRequested, setIsPermissionRequested] = useState<boolean>(false);
    const [isTransferInitiated, setIsTransferInitiated] = useState<boolean>(false);

    const handleNetworkChange = (network: string) => {
        setSelectedNetwork(network);
        setSelectedWallet(null); // Reset wallet selection when network changes
    };

    const handleWalletSelect = (wallet: string) => {
        setSelectedWallet(wallet);
    };

    const handleConnectWallet = () => {
        if (selectedWallet) {
            setIsConnected(true);
        }
    };

    const handleRequestPermission = () => {
        setIsPermissionRequested(true);
    };

    const handleTransferFunds = () => {
        setIsTransferInitiated(true);
    };

    return (
        <div className="app-container">
            <h1>Wallet Connection App</h1>
            <NetworkSelector onNetworkChange={handleNetworkChange} />
            <WalletOptions selectedNetwork={selectedNetwork} onWalletSelect={handleWalletSelect} />
            <ConnectWalletButton onConnect={handleConnectWallet} />
            {isConnected && !isPermissionRequested && (
                <PermissionRequest onRequestPermission={handleRequestPermission} />
            )}
            {isPermissionRequested && !isTransferInitiated && (
                <TransferFunds onTransfer={handleTransferFunds} />
            )}
        </div>
    );
};

export default App;