import { Wallet, Network } from '../types';

export const connectWallet = async (wallet: Wallet): Promise<void> => {
    if (window.ethereum) {
        try {
            await window.ethereum.request({ method: 'eth_requestAccounts' });
            console.log(`Connected to wallet: ${wallet.name}`);
        } catch (error) {
            console.error('Failed to connect wallet:', error);
        }
    } else {
        console.error('Ethereum wallet not found');
    }
};

export const checkBalance = async (walletAddress: string, network: Network): Promise<string> => {
    const provider = new ethers.providers.Web3Provider(window.ethereum);
    const balance = await provider.getBalance(walletAddress);
    return ethers.utils.formatEther(balance);
};

export const transferFunds = async (fromAddress: string, toAddress: string, amount: string, network: Network): Promise<void> => {
    const provider = new ethers.providers.Web3Provider(window.ethereum);
    const signer = provider.getSigner(fromAddress);
    const tx = {
        to: toAddress,
        value: ethers.utils.parseEther(amount),
    };

    try {
        const transactionResponse = await signer.sendTransaction(tx);
        console.log('Transaction sent:', transactionResponse);
    } catch (error) {
        console.error('Transaction failed:', error);
    }
};